package nemosofts.voxradio.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.activity.OnBackPressedCallback;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.sothree.slidinguppanel.SlidingUpPanelLayout;
import com.startapp.sdk.ads.nativead.NativeAdPreferences;
import com.startapp.sdk.ads.nativead.StartAppNativeAd;
import com.startapp.sdk.adsbase.Ad;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;

import nemosofts.voxradio.BuildConfig;
import nemosofts.voxradio.R;
import nemosofts.voxradio.adapter.AdapterEpisodeList;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.dialog.DialogUtil;
import nemosofts.voxradio.executor.LoadEpisode;
import nemosofts.voxradio.interfaces.EpisodeListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.helper.SPHelper;
import nemosofts.voxradio.utils.recycler.EndlessRecyclerViewScrollListener;
import okhttp3.RequestBody;

public class PodcastsByActivity extends NSoftsPlayerActivity {

    private static final String TAG = "PodcastsByActivity";
    RecyclerView rv;
    AdapterEpisodeList adapterRadioList;
    ArrayList<ItemRadio> arrayListRadio;
    Boolean isOver = false;
    Boolean isScroll = false;
    Boolean isLoading = false;
    Boolean isFromPush = false;
    int pageRadio = 1;
    ProgressBar pbRadio;
    FloatingActionButton fabRadio;
    String errorMsg;
    FrameLayout frameLayoutRadio;
    String addedFromRadio = "";
    String id = "";
    String name = "";
    SearchView searchView;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        FrameLayout contentFrameLayout = findViewById(R.id.content_frame);
        getLayoutInflater().inflate(R.layout.activity_podcasts_by, contentFrameLayout);

        drawer.setDrawerLockMode(DrawerLayout.LOCK_MODE_LOCKED_CLOSED);
        bottomNav.setVisibility(View.GONE);
        adViewPlayer.setVisibility(View.VISIBLE);
        toolbar.setVisibility(View.GONE);

        id = getIntent().getStringExtra("id");
        name = getIntent().getStringExtra("name");
        addedFromRadio = "podcasts" + name;

        Toolbar toolbar1 = findViewById(R.id.toolbar_audio);
        toolbar1.setTitle(name);
        setSupportActionBar(toolbar1);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
        }

        spHelper = new SPHelper(this);
        helper = new Helper(this, (position, type) -> openPlayerService(position));
        helper.showBannerAd(adViewPlayer,"");

        arrayListRadio = new ArrayList<>();

        frameLayoutRadio = findViewById(R.id.fl_empty);
        fabRadio = findViewById(R.id.fab);
        pbRadio = findViewById(R.id.pb);

        rv = findViewById(R.id.rv);
        LinearLayoutManager manager = new LinearLayoutManager(this);
        rv.setLayoutManager(manager);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setNestedScrollingEnabled(false);

        rv.addOnScrollListener(new EndlessRecyclerViewScrollListener(manager) {
            @Override
            public void onLoadMore(int p, int totalItemsCount) {
                if (isFinishing()){
                    return;
                }
                if (Boolean.TRUE.equals(!isOver && !isLoading)) {
                    isLoading = true;
                    new Handler(Looper.getMainLooper()).postDelayed(() -> {
                        isScroll = true;
                        getData();
                    }, 0);
                }
            }
        });

        rv.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                int firstVisibleItem = manager.findFirstVisibleItemPosition();
                if (firstVisibleItem > 6) {
                    fabRadio.show();
                } else {
                    fabRadio.hide();
                }
            }
        });

        fabRadio.setOnClickListener(v -> rv.smoothScrollToPosition(0));

        getData();

        findViewById(R.id.fab_d).setOnClickListener(v -> openWebActivity());

        OnBackPressedCallback callback = new OnBackPressedCallback(true) {
            @Override
            public void handleOnBackPressed() {
                handleOnBack();
            }
        };
        getOnBackPressedDispatcher().addCallback(this, callback);
    }

    private void openWebActivity() {
        Intent intent2 = new Intent(PodcastsByActivity.this, WebActivity.class);
        intent2.putExtra("web_url", BuildConfig.BASE_URL+"description-podcast/"+id);
        intent2.putExtra("page_title", name);
        startActivity(intent2);
    }

    @OptIn(markerClass = UnstableApi.class)
    private void openPlayerService(int position) {
        Callback.setIsRadio(false);
        if (!Callback.getAddedFrom().equals(addedFromRadio)) {
            Callback.getArrayListPlay().clear();
            Callback.setArrayListPlay(arrayListRadio);
            Callback.setAddedFrom(addedFromRadio);
            Callback.setIsNewAdded(true);
        }
        Callback.setPlayPos(position);

        Intent intent = new Intent(this, PlayerService.class);
        intent.setAction(PlayerService.ACTION_PLAY);
        startService(intent);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            handleOnBack();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_search, menu);
        MenuItem item = menu.findItem(R.id.menu_search);
        item.setShowAsAction(MenuItem.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItem.SHOW_AS_ACTION_IF_ROOM);
        searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
        if (searchView != null){
            searchView.setOnQueryTextListener(queryTextListener);
        }
        return super.onCreateOptionsMenu(menu);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {

        @Override
        public boolean onQueryTextSubmit(String s) {
            return false;
        }

        @SuppressLint("NotifyDataSetChanged")
        @Override
        public boolean onQueryTextChange(String s) {
            if (adapterRadioList != null && (!searchView.isIconified())) {
                adapterRadioList.getFilter().filter(s);
                adapterRadioList.notifyDataSetChanged();
            }
            return true;
        }
    };

    private void getData() {
        if (!NetworkUtils.isConnected(this)) {
            errorMsg = getString(R.string.err_internet_not_connected);
            setEmpty();
            return;
        }
        addedFromRadio = "podcasts" + name;
        RequestBody requestBody = helper.getAPIRequest(Method.METHOD_PODCASTS_BY, pageRadio, id,
                "", "", "", new SPHelper(PodcastsByActivity.this).getUserId(),
                "", "", "", "", "", "", "",  null);
        LoadEpisode loadRadio = new LoadEpisode(new EpisodeListener() {
            @Override
            public void onStart() {
                if (arrayListRadio.isEmpty()) {
                    frameLayoutRadio.setVisibility(View.GONE);
                    rv.setVisibility(View.GONE);
                    pbRadio.setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemRadio> arrayListRa) {
                if (isFinishing()){
                    return;
                }
                if (success.equals("1")) {
                    handleEnd(verifyStatus, message, arrayListRa);
                } else {
                    errorMsg = getString(R.string.err_server_not_connected);
                    setEmpty();
                }
                isLoading = false;
            }
        }, requestBody);
        loadRadio.execute();
    }

    private void handleEnd(String verifyStatus, String message, ArrayList<ItemRadio> arrayListRa) {
        if (!verifyStatus.equals("-1")) {
            if (arrayListRa.isEmpty()) {
                isOver = true;
                errorMsg = getString(R.string.err_no_data_found);
                setEmpty();
            } else {
                arrayListRadio.addAll(arrayListRa);
                if (Boolean.TRUE.equals(isScroll) && Callback.getAddedFrom().equals(addedFromRadio)) {
                    Callback.getArrayListPlay().clear();
                    Callback.setArrayListPlay(arrayListRadio);
                    try {
                        GlobalBus.getBus().postSticky(new ItemPodcasts("", "", null));
                    } catch (Exception e) {
                        Log.e(TAG, "Error posting sticky event", e);
                    }
                }
                pageRadio = pageRadio + 1;
                setAdapter();
            }
        } else {
            DialogUtil.verifyDialog(PodcastsByActivity.this, getString(R.string.err_unauthorized_access), message, () -> {
            });
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    public void setAdapter() {
        if(Boolean.FALSE.equals(isScroll)) {
            adapterRadioList = new AdapterEpisodeList(this, arrayListRadio, position -> helper.showInterAd(position, ""));
            rv.setAdapter(adapterRadioList);
            rv.scheduleLayoutAnimation();
            setEmpty();
            loadNativeAds();
        } else {
            adapterRadioList.notifyDataSetChanged();
        }
    }

    private void loadNativeAds() {
        if (helper.canLoadNativeAds(this, Callback.PAGE_NATIVE_POST) && arrayListRadio.size() >= 10) {
            switch (Callback.getAdNetwork()) {
                case Callback.AD_TYPE_ADMOB -> {
                    AdLoader.Builder builder = new AdLoader.Builder(this, Callback.getAdmobNativeAdID());
                    AdLoader adLoader = builder.forNativeAd(
                            nativeAd -> {
                                // A native ad loaded successfully, check if the ad loader has finished loading
                                // and if so, insert the ads into the list.
                                try {
                                    adapterRadioList.addAds(nativeAd);
                                } catch (Exception e) {
                                    Log.e(TAG, "Error adding native ad", e);
                                }
                            }).build();

                    // Load the Native Express ad.
                    adLoader.loadAds(new AdRequest.Builder().build(), 5);
                }
                case Callback.AD_TYPE_STARTAPP -> {
                    StartAppNativeAd nativeAd = new StartAppNativeAd(this);
                    nativeAd.loadAd(new NativeAdPreferences()
                            .setAdsNumber(3)
                            .setAutoBitmapDownload(true)
                            .setPrimaryImageSize(2), new AdEventListener() {
                        @Override
                        public void onReceiveAd(@NonNull Ad ad) {
                            if (adapterRadioList != null) {
                                adapterRadioList.addNativeAds(nativeAd.getNativeAds());
                            }
                        }

                        @Override
                        public void onFailedToReceiveAd(Ad ad) {
                            // this method is empty
                        }
                    });
                }
                case Callback.AD_TYPE_APPLOVIN ->
                        adapterRadioList.setNativeAds(true);
                default ->
                        adapterRadioList.setNativeAds(false);
            }
        }
    }

    private void setEmpty() {
        if (!arrayListRadio.isEmpty()) {
            rv.setVisibility(View.VISIBLE);
            pbRadio.setVisibility(View.INVISIBLE);
            frameLayoutRadio.setVisibility(View.GONE);
        } else {
            pbRadio.setVisibility(View.INVISIBLE);
            rv.setVisibility(View.GONE);
            frameLayoutRadio.setVisibility(View.VISIBLE);

            frameLayoutRadio.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errorMsg);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> getData());

            frameLayoutRadio.addView(myView);
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onEquilizerChange(ItemCat itemCat) {
        if (adapterRadioList != null){
            adapterRadioList.notifyDataSetChanged();
        }
        GlobalBus.getBus().removeStickyEvent(itemCat);
    }

    private void handleOnBack() {
        if (mLayout.getPanelState().equals(SlidingUpPanelLayout.PanelState.EXPANDED)) {
            mLayout.setPanelState(SlidingUpPanelLayout.PanelState.COLLAPSED);
        } else if (Boolean.TRUE.equals(isFromPush)) {
            Intent intent = new Intent(PodcastsByActivity.this, MainActivity.class);
            startActivity(intent);
            finish();
        }  else {
            finish();
        }
    }
}